<?php

/**
 * Header Template
 *
 * This file contains the site header structure including the document head,
 * site navigation, logo, search functionality, and opening page wrapper.
 * Used by all theme templates.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

$id = get_the_ID();
$wvc_editor_meta = \WVC\Core\Core::get_wvc_editor_meta($id);

# if this is vibecode page, then we need to output the HTML template

# if there is a header template, then we need to output it instead of the default header

$has_wvc_header_template = false;
$header_content = '';

if (!$wvc_editor_meta) {
	// Check for WVC header template in case of regular page
	$header_template = get_posts(array(
		'post_type' => 'wvc_template',
		'post_status' => 'publish',
		'meta_query' => array(
			array(
				'key' => '_wvc_template_type',
				'value' => 'header',
				'compare' => '='
			)
		),
		'posts_per_page' => 1,
		'orderby' => 'ID',
		'order' => 'ASC'
	));

	if (!empty($header_template)) {
		$has_wvc_header_template = true;
		$header_post = $header_template[0];
		$header_content = $header_post->post_content;
	}
}
if ($wvc_editor_meta || $has_wvc_header_template):

	// Pass variables to the template using get_template_part with args
	get_template_part('wvc-header', null, array(
		'header_content' => $header_content,
		'has_wvc_header_template' => $has_wvc_header_template
	));

	return;
endif;



?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>

	<div id="page" class="site min-h-screen flex flex-col">
		<a class="skip-link sr-only focus:not-sr-only focus:absolute focus:top-4 focus:left-4 bg-primary-500 text-white px-4 py-2 rounded-md z-50" href="#main"><?php _e('Skip to content', 'wvc-theme'); ?></a>

		<header id="masthead" class="site-header bg-white border-b border-gray-500 sticky top-0 z-40">
			<div class="container mx-auto px-4 sm:px-6 lg:px-8 max-w-7xl">
				<div class="header-content flex items-center justify-between py-4">
					<div class="site-branding flex items-center">
						<?php if (has_custom_logo()) : ?>
							<div class="site-logo">
								<?php the_custom_logo(); ?>
							</div>
						<?php else : ?>
							<h1 class="site-title text-2xl font-bold text-black">
								<a href="<?php echo esc_url(home_url('/')); ?>" rel="home" class="text-black hover:text-primary-600 transition-colors duration-200">
									<?php bloginfo('name'); ?>
								</a>
							</h1>
							<?php
							$description = get_bloginfo('description', 'display');
							if ($description || is_customize_preview()) :
							?>
								<p class="site-description text-gray-600 text-sm ml-4"><?php echo $description; ?></p>
							<?php endif; ?>
						<?php endif; ?>
					</div>

					<nav id="site-navigation" class="main-navigation">
						<button class="menu-toggle md:hidden bg-primary-500 hover:bg-primary-600 text-white p-2 rounded-md transition-colors duration-200" aria-controls="primary-menu" aria-expanded="false">
							<span class="sr-only"><?php _e('Primary Menu', 'wvc-theme'); ?></span>
							<span class="menu-icon flex flex-col space-y-1">
								<span class="w-6 h-0.5 bg-white block"></span>
								<span class="w-6 h-0.5 bg-white block"></span>
								<span class="w-6 h-0.5 bg-white block"></span>
							</span>
						</button>

						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'primary',
								'menu_id'        => 'primary-menu',
								'container'      => false,
								'menu_class'     => 'primary-menu hidden md:flex md:items-center md:space-x-8',
								'fallback_cb'    => 'wp_page_menu',
								'walker'         => new class extends Walker_Nav_Menu {
									public function start_el(&$output, $item, $depth = 0, $args = null, $id = 0)
									{

										$before = isset($args->before) ? $args->before : "";
										$after = isset($args->after) ? $args->after : "";
										$link_before = isset($args->link_before) ? $args->link_before : "";
										$link_after = isset($args->link_after) ? $args->link_after : "";

										$classes = empty($item->classes) ? array() : (array) $item->classes;
										$classes[] = 'menu-item-' . $item->ID;

										$class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
										$class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';

										$id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args);
										$id = $id ? ' id="' . esc_attr($id) . '"' : '';

										$output .= '<li' . $id . $class_names . '>';

										$attributes  = ! empty($item->attr_title) ? ' title="'  . esc_attr($item->attr_title) . '"' : '';
										$attributes .= ! empty($item->target)     ? ' target="' . esc_attr($item->target) . '"' : '';
										$attributes .= ! empty($item->xfn)        ? ' rel="'    . esc_attr($item->xfn) . '"' : '';
										$attributes .= ! empty($item->url)        ? ' href="'   . esc_attr($item->url) . '"' : '';

										$item_output = $before;
										$item_output .= '<a' . $attributes . ' class="text-black hover:text-primary-600 transition-colors duration-200 font-medium">';
										$item_output .= $link_before . apply_filters('the_title', $item->title, $item->ID) . $link_after;
										$item_output .= '</a>';
										$item_output .= $after;

										$output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
									}
								},
							)
						);
						?>
					</nav>


				</div>


			</div>
		</header>

		<div id="content" class="site-content flex-grow">