<?php

namespace WVC\FormSubmissions;

/**
 * WVC Form Submissions Post Type Registration
 *
 * Registers custom post type for form submissions
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.16
 */

// Prevent direct access
if ( ! defined("ABSPATH")) {
    exit;
}

/**
 * Register custom post type for form submissions
 */
function wvc_register_form_data_post_type() {
    register_post_type('wvc_form_data', array(
        'labels' => array(
            'name' => 'Form Submissions',
            'singular_name' => 'Form Submission',
            'menu_name' => 'Form Data',
            'add_new' => 'Add New',
            'add_new_item' => 'Add New Form Submission',
            'edit_item' => 'Edit Form Submission',
            'new_item' => 'New Form Submission',
            'view_item' => 'View Form Submission',
            'search_items' => 'Search Form Submissions',
            'not_found' => 'No form submissions found',
            'not_found_in_trash' => 'No form submissions found in trash'
        ),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => false, // Hide the default menu
        'capability_type' => 'post',
        'hierarchical' => false,
        'rewrite' => false,
        'query_var' => false,
        'supports' => array('title', 'custom-fields'),
        'menu_icon' => 'dashicons-forms',
        'menu_position' => 30
    ));
}