<?php

/**
 * Page Template
 *
 * This template displays individual pages. It handles the page content-managers display,
 * comments (if enabled), and page-specific functionality. Used for static pages
 * created through the WordPress admin.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */



$id = get_the_ID();
$wvc_editor_meta = \WVC\Core\Core::get_wvc_editor_meta($id);

# if this is vibecode page, then we need to output the HTML template

if ($wvc_editor_meta): 

    get_template_part("wvc-page");

    return;
endif;
?>




<?php
// Only output HTML template if wvc-editor meta is not set or is empty
get_header();
 ?>



    <main class="site-main bg-white min-h-screen">
        <div class="container mx-auto px-4 py-8 max-w-7xl">
            <div class="grid grid-cols-1 gap-8">
                <div class="content-area lg:col-span-2">
                    <?php while (have_posts()) : the_post(); ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class("page"); ?>>
                            <header class="page-header bg-primary-100 p-6 border-b border-gray-200">
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="page-thumbnail mb-6">
                                        <?php the_post_thumbnail("large", array("class" => "w-full h-auto rounded-lg shadow-sm")); ?>
                                    </div>
                                <?php endif; ?>

                                <h1 class="page-title text-3xl font-bold text-black mb-4"><?php the_title(); ?></h1>
                            </header>

                            <div class="page-content p-6 bg-white">
                                <div class="prose prose-lg max-w-none text-black">
                                    <?php the_content(); ?>
                                </div>

                                <?php
                                wp_link_pages(
                                    array(
                                        "before" => "<div class=\"page-links mt-8 p-4 bg-gray-100 rounded-lg\"><span class=\"font-semibold text-black\">" . esc_html__("Pages:", "wvc-theme") . "</span>",
                                        "after"  => "</div>",
                                    )
                                );
                                ?>
                            </div>
                        </article>

                        <?php
                        // If comments are open or we have at least one comment, load up the comment template.
                        if (comments_open() || get_comments_number()) :
                            echo '<div class="mt-8 bg-white rounded-lg shadow-md overflow-hidden">';
                            comments_template();
                            echo '</div>';
                        endif;
                        ?>

                    <?php endwhile; ?>
                </div>

                <div class="sidebar-area lg:col-span-1">
                    <?php get_sidebar(); ?>
                </div>
            </div>
        </div>
    </main>

<?php

get_footer();
?>